/*
  This example was written in CVI version 5.5.1 in Win2KSP1
  
  It used a KPCI-PIO24 with kpcipio-850A04 of the driver
  
  Important Compiler Defines for the project:  /DWIN32_LEAN_AND_MEAN  /D_MSC_VER=0
  
  This example is suitable also for KPCI-PIO96 with minor modification.
  
  Channels of KPCI-PIO24: 0 through 2
  Channels of KPCI-PIO96: 0 through 11
               
*/

static int stat;
#include <cvirte.h>		/* Needed if linking in external compiler; harmless otherwise */
#include <userint.h>
#include "sample.h"
#include <windows.h>
#include <ansi_c.h>
#include "drvlinx.h"
#include "dlcodes.h"
static int panelHandle;
unsigned char DOChan;
unsigned char DevNum;


HWND window;
HINSTANCE driverInstance; // need a handle for our instance of the open driver
DL_SERVICEREQUEST *pSR;  // declare a service request structure     

	
int main (int argc, char *argv[])
{
	
	if (InitCVIRTE (0, argv, 0) == 0)	/* Needed if linking in external compiler; harmless otherwise */
		return -1;	/* out of memory */
	if ((panelHandle = LoadPanel (0, "sample.uir", MAINPANEL)) < 0)
		return -1;
	DisplayPanel (panelHandle);
	RunUserInterface ();
	return 0;
}


int CVICALLBACK quit (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event) {
		case EVENT_COMMIT:
		    if (pSR != NULL)
		    {
			free(pSR);
			pSR = NULL;
			}
			CloseDriverLINX(driverInstance);
			QuitUserInterface (0);
			
			break;
	}
	return 0;
}

int CVICALLBACK Initialize (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event) {
		case EVENT_COMMIT:
		    //Get the Window handle from the CVI panel
			window=FindWindow(NULL,"KPCI-PIOxx Driver Example"); 
			//Pass the window handle to open the driver function
			driverInstance=OpenDriverLINX(window,"kpcipio");  
			// could use GetDesktopWindow() for generic handle if your application does not have a panel
			// AND will not make use of messages......
			pSR=(DL_SERVICEREQUEST*)malloc(sizeof(DL_SERVICEREQUEST));  //Allocate space for the Service Request
			memset(pSR,0,sizeof(DL_SERVICEREQUEST));   //Initialize the Service Request members
			DL_SetServiceRequestSize(*pSR);    	//Setup the Service Request for usage
			pSR->hWnd=window;                	//Set the Widows handle property
			// get the requested device number
			GetCtrlVal(panel,MAINPANEL_DEVNUM,&DevNum);
			pSR->device=DevNum; 			//Set the device property from the panel control	
			pSR->subsystem=DEVICE;				//We are commnicating with the DEVICE, not AI, AO, etc..																		
			pSR->mode=OTHER;					//The mode is OTHER, not DMA or INTerrupt
			pSR->operation=INITIALIZE;			//The operation is to INITIALIZE the driver													 
			DriverLINX(pSR);					//Execute the Service Request
			
			if(pSR->result!=NoErr)				//Check for errors
			{
				pSR->operation=MESSAGEBOX;
				DriverLINX(pSR);
			}
			else
			{
			 SetCtrlAttribute(panel,MAINPANEL_COMMANDBUTTON_4,ATTR_DIMMED,0); // enable other buttons
			 SetCtrlAttribute(panel,MAINPANEL_CONFIGURE,ATTR_DIMMED,0);
			}
			SetActivePanel (panel); // set focus back to our panel
			break;
	}
	return 0;
}

int CVICALLBACK cmdConfig (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
			// get the requested channel number
			GetCtrlVal(panel,MAINPANEL_DO_CHAN,&DOChan);
			// configure this channel for output direction
			pSR->operation=CONFIGURE;
	        pSR->subsystem=DO;   // config the channel to the DO subsystem
	        // use DI in above to re-assign it for input......
	        pSR->mode=OTHER;
	        pSR->timing.typeEvent = DIOSETUP;
            pSR->timing.u.diSetup.channel = DOChan;  // config the channel specified by the panel control
            pSR->timing.u.diSetup.mode = DIO_BASIC;
	        DriverLINX(pSR); //Execute the service request
	        if(pSR->result!=NoErr)				//Check for errors
			{
				pSR->operation=MESSAGEBOX;
				DriverLINX(pSR);
			}
			else
			{
			 SetCtrlAttribute(panel,MAINPANEL_COMMANDBUTTON_3,ATTR_DIMMED,0); // enable other buttons
			 SetCtrlAttribute(panel,MAINPANEL_COMMANDBUTTON_5,ATTR_DIMMED,0);
			 SetCtrlAttribute(panel,MAINPANEL_CONFIGURE,ATTR_DIMMED,1); // disable the configure button
			}
			break;
		}
	return 0;
}

int CVICALLBACK read_di (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
			pSR->subsystem = DI;				//Talk to the Digital Input subsystem
			pSR->mode = POLLED;					//The mode is POLLED, not DMA ot INTerrupt
			pSR->channels.nChannels=1;			//The total number of channels is 1
			pSR->channels.chanGain[0].channel=0;//We are talking to channel 0
			pSR->status.typeStatus=IOVALUE;		//We are getting an I/O value
			pSR->operation = START;		    	//The operation is to START
			pSR->timing.typeEvent = NULLEVENT;
			DriverLINX(pSR);					//Execute the Service Request

			if(pSR->result!=NoErr)				//Check for errors
			{
				pSR->operation=MESSAGEBOX;
				DriverLINX(pSR);
			}
			else
			{
			 // display the value
			 SetCtrlVal (panel, MAINPANEL_NUMERIC, pSR->status.u.ioValue);
			 // a polled mode single sample can live in status.u.ioValue member 
			 }

		break;
		}
	return 0;
}

int CVICALLBACK digout (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event) {
		case EVENT_COMMIT:
			pSR->mode=POLLED;					//The mode is POLLED I/O
			pSR->subsystem = DO;
			pSR->channels.nChannels=1;			//The total number of channels is 1
			pSR->channels.chanGain[0].channel=DOChan;//channel from the panel control 
			pSR->status.typeStatus=IOVALUE;		//We are sending an I/O value
			pSR->status.u.ioValue=255;			//We are sending a value of 255,i.e. all 8 lines are high
			pSR->operation = START;				//The operation is to START
			pSR->timing.typeEvent = NULLEVENT;  // no timing event required
			
			DriverLINX(pSR);					//Execute the Service Request
			
			if(pSR->result!=NoErr)				//Check for errors
			{
				pSR->operation=MESSAGEBOX;
				DriverLINX(pSR);
			}
			break;
	}
	return 0;
}

int CVICALLBACK allLow (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
		    pSR->mode=POLLED;					//The mode is POLLED I/O
		    pSR->subsystem = DO;
			pSR->channels.nChannels=1;			//The total number of channels is 1
			pSR->channels.chanGain[0].channel=DOChan;//channel from the panel control
			pSR->status.typeStatus=IOVALUE;		//We are sending an I/O value
			pSR->status.u.ioValue=0;			//We are sending a value of 0
			pSR->operation = START;				//The operationi is to START
			pSR->timing.typeEvent = NULLEVENT;  // no timing event required
			
			DriverLINX(pSR);					//Execute the Service Request
			
			if(pSR->result!=NoErr)				//Check for errors
			{
				pSR->operation=MESSAGEBOX;
				DriverLINX(pSR);
			}
			break;
		}
	return 0;
}
